<?php
function RecalculeMontantRestantDuFormule($idEcole,$idClient,$idFormule,$host,$paramDTF){
	$formuleInfo=GetFormuleInfosBD($idEcole,$idFormule);
	$linkIdFactureGroupee=$formuleInfo['idFactureGroupee'];
	if($linkIdFactureGroupee!=-1){
		UpdateRestantDuFactureGroupee($idEcole,$linkIdFactureGroupee,$formuleInfo['isDevis'],$paramDTF);
		$prixTotalFormule=0;
	}
	else{
		$discount=$formuleInfo['discount'];
		$dateCreation=$formuleInfo['dateCreation'];
		$totalDejaPaye=0;
		$cpt=0;
		$paiements=GetPaiement($idEcole,$idFormule,$dateCreation);
		foreach($paiements as $paiement){
			$totalDejaPaye+=$paiement['montant'];
		}
		$prixTotalFormuleTemp=GetPrixFormule($idEcole,$idFormule,$discount);//Prend en compte le discount, et le calcul pour les groupes
		$prixTotalFormule=$prixTotalFormuleTemp['totalApresRemise'];
		$prixFormule=$prixTotalFormule-$totalDejaPaye;
		$nouveauRestantDu=round($prixFormule*100)/100;
		$modif=ModifyRestantDuFormuleBD($idEcole,$idFormule,$nouveauRestantDu,$prixTotalFormuleTemp['total'],$prixTotalFormuleTemp['totalApresRemise'],$prixTotalFormuleTemp['montantDeLaRemise']);//L'ecriture en base inclue le raz du flag suivant AddFlagFormuleNeedToAddDtfBD($idEcole,$id,"");
		$descriptifArticle['display']="";
		$descriptifArticle['listingMoniteur']="";
		if($idEcole==1409){//pour carole de surfunivers, ajouter le nom des moniteurs
			$descriptifArticle=GetMoniteurDeLaFormule($idEcole,$idFormule);
		}
		$descriptifArticle['display'].=GetLeconsInfosFromFormuleDisplayForPdf($idEcole,$idFormule);
		$descriptifArticle['display'].=" ".$formuleInfo['commentaire'];
		$paramDTF=AddupDTFParameters($paramDTF,$formuleInfo['tauxTVA'],"formule: ".$formuleInfo['nom']." (".$formuleInfo['sport'].")",$descriptifArticle['display'],$prixTotalFormuleTemp['total'],$prixTotalFormuleTemp['totalApresRemise'],$prixTotalFormuleTemp['montantDeLaRemise'],$prixTotalFormuleTemp['displayDTF'],$paiements,$nouveauRestantDu,"formule",$descriptifArticle['listingMoniteur']);
		AddDTF($idEcole,"formule",$idFormule,$formuleInfo['isDevis'],$paramDTF);
		AjouterLesFichiersPlanningsaTransfererDeLaFormule($idEcole,$idFormule,$host);
	}
	return $prixTotalFormule;
}
function GetPrixFormule($idEcole,$idFormule,$discount){
	$formuleInfo=GetFormuleInfosBD($idEcole,$idFormule);
	$idTypeFormule=$formuleInfo['idTypeFormule'];
	$valeursDispo=GetFourchetteNbLeconAvecPrixCorrespondants($idTypeFormule);
	$nbLeconsAComptabiliser=GetNbPrensenceFormule($idEcole,$idFormule);
	if($nbLeconsAComptabiliser==-1){
		$nbLeconsAComptabiliser=GetNbLeconsAchetesDansFormule($idEcole,$idFormule);
	}
	$ret=Array();
	if($nbLeconsAComptabiliser==0){//Possible avec le skate, si on n'a coché personne encore dans le planning, on a ca a 0, le prix est donc de 0, meme si il n'est pas dans une tranche de prix...
		$ret['total']=0;
		$ret['prixUnitaire']=-1;
	}
	elseif($valeursDispo[0][1]==-1){//si on est en formule libre (choix du prix, puis choix du nb lecons)
		$prixUnitaire=GetPrixLibreUnitaire($idFormule);
		$ret['total']=$prixUnitaire*$nbLeconsAComptabiliser;
		$ret['prixUnitaire']=$prixUnitaire;
	}
	else{//Formule classique avec tranches, ou multiple
		foreach($valeursDispo as $valeurDispo){
			if($valeurDispo[0]==$nbLeconsAComptabiliser){
				$ret['total']=$valeurDispo[1];
				$ret['prixUnitaire']=-1;
			}
		}
	}
	//Ajout de la suite, ENFIN!
	$nbParticipants=GetNbParticipantsTotalPourUneFormule($idEcole,$idFormule);
	$ret['nbParticipants']=$nbParticipants;
	$ret['total']=$ret['total']*$nbParticipants[0]/$nbParticipants[1];
	$ret['total']=round($ret['total']*100)/100;
	$ret['totalApresRemise']=$ret['total'];
	$ret['montantDeLaRemise']=0;
	$ret['displayMoinsRemiseEgalTotalRemise']="";
	$ret['displayApresTantDeRemise']="";
	$ret['displayDTF']=0;
	$ret['tauxTVA']=$formuleInfo['tauxTVA'];
	$ret['isDevis']=$formuleInfo['isDevis'];
	$ret['isDeleted']=$formuleInfo['isDeleted'];
	if($discount!=0){
		$prixAjusteApresRemise=AjustePrixApresRemise($ret['total'],$discount);
		$ret['totalApresRemise']=$prixAjusteApresRemise['montantApresRemise'];
//Putain de blague!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
//https://stackoverflow.com/questions/17210787/php-float-calculation-error-when-subtracting
//		$ret['montantDeLaRemise']=$ret['total']-$ret['totalApresRemise'];
		$ret['montantDeLaRemise']=(floor($ret['total']*100)-floor($ret['totalApresRemise']*100))/100;
		$ret['displayMoinsRemiseEgalTotalRemise']=" - ".$prixAjusteApresRemise['displayMontantDeLaRemise']." = ".$ret['totalApresRemise']." €";
		$ret['displayApresTantDeRemise']=" (apres ".$prixAjusteApresRemise['displayMontantDeLaRemise']." de remise)";
		$ret['displayDTF']=$prixAjusteApresRemise['displayMontantDeLaRemise'];
	}
	return $ret;
}
function GetFourchetteNbLeconAvecPrixCorrespondants($idTypeFormule){
	//Petite explication: on a des fouchettes de prix qui dépendent du nombre de leçons prises... tarif dégressif.
	//exemple: en base on a nb_lecon=1-4;5-9;10-20 et prix=35;30;28
	//Donc pour 1, 2, 3 ou 4 leçons, le prix unitaire est de 35€ la lecon
	//$ret[6][0]= nb de lecons		ex: 6
	//$ret[6][1]= prix correspondant	ex: 6*30=180

	//Voila voila voila, sauf que nico padois, pour ocean roots, il fait tout à fait autrement
	//Il fait les leçons à 35€, et toutes les 5 leçons le leçon est à 15€.
	//Donc tous les multiples de 5 sont à 15€ et toutes les autres sont à 35;

	//Donc on va combiner les deux... pour un intervalle donné, le prix "normalement" est de 35
	//Ici on va avoir en base 35!5!15
	//35 euros la leçon, toutes les 5 leçons, on a le prix à 15€

	//Comme ca on peut garder le meme fonctionnement, juste une petite condition à ajouter

	//WARNING Si on fait le plan "multiple de", on aura une seule tranche, car à chaque fois on va calculer
	//combien de multiples il y a eu depuis la première leçon... Donc pour une seconde tranche, on serait bien emmerdé... ou pas?

	$fouchettesLecons=GetFourchettesNbLeconsDansTypeFormule($idTypeFormule);//   1-4;5-9;10-20 par exemple
	$prixs=GetFourchettesPrixTypeFormule($idTypeFormule);//			35;30;28   pour suivre l'exemple

	$fouchetteLecons=GetValuesFromComaList($fouchettesLecons,";");//   [1-4][5-9][10-20]
	$prix=GetValuesFromComaList($prixs,";");//			[35][30][28]
	$arrondi=GetArrondiLesPrixTypeFormule($idTypeFormule);//1 pour oui, on arrondi
	$ret=Array();
	$cptGlobal=0;
	$cptTranche=0;
	foreach($fouchetteLecons as $fouchetteLecon){//Pour chaque tranche
		$prixTranche=$prix[$cptTranche];
		$casMultipleDe=false;
		if(strpos("xxx".$prixTranche,"!")!=0){//Si on a un "!" on est dans le cas "multiple de" ocean roots
			$prixTranche=GetValuesFromComaList($prixTranche,"!");
			$prixToutesLecons=$prixTranche[0];
			$multipleDe=$prixTranche[1];
			$prixDuMultiple=$prixTranche[2];
			$casMultipleDe=true;
		}
		$vs=GetValuesFromComaList($fouchetteLecon,"-");
		for($indiceNbLeconCourant=$vs[0];$indiceNbLeconCourant<=$vs[1];$indiceNbLeconCourant++){//pour chaques valeurs de la tranche (de l'intervale)
			$ret[$cptGlobal][0]=$indiceNbLeconCourant;
			if($casMultipleDe){//Cas multiple de, ocean roots
				$ret[$cptGlobal][1]=0;
				for($indiceDepuisUn=1;$indiceDepuisUn<=$indiceNbLeconCourant;$indiceDepuisUn++){//on compte toutes les lecons depuis la première
					if($indiceDepuisUn%$multipleDe==0){
						$ret[$cptGlobal][1]+=$prixDuMultiple;
					}
					else{
						$ret[$cptGlobal][1]+=$prixToutesLecons;
					}
				}
			}
			elseif($prixTranche==-1){//Cas du prix variable
				$ret[$cptGlobal][1]=-1;
			}
			else{//Cas normal par tranches au prix degressif
				$priii=$indiceNbLeconCourant*$prixTranche;
				$ret[$cptGlobal][1]=$priii;
				if($arrondi){
					$ret[$cptGlobal][1]=round($priii);
				}
			}
			$cptGlobal++;
		}
		$cptTranche++;
	}
	return $ret;
}
function GetNbPrensenceFormule($idEcole,$idFormule){
	//Retourne -1 si facturation presence pas activée
	//Et le nombre de check si activée
	$idTypeFormule=GetIdTypeFormule($idFormule);
	$facturationSurPrensence=GetFacturationSurPresenceTypeFormule($idTypeFormule);
	$ret=-1;
	if($facturationSurPrensence==1){
		$ret=GetNbPrensenceFormuleBD($idFormule);
	}
	return $ret;
}
function GetNbLeconsAchetesDansFormule($idEcole,$idFormule){
	$paramInTheEnd=" link_id_formule=".$idFormule;
	$allEnregistrements=GetAllTableInfo("lecon",$idEcole,$paramInTheEnd);
	$cpt=0;
	foreach($allEnregistrements as $allEnregistrement){
		$cpt++;
	}
	return $cpt;
}
function GetPrixLibreUnitaire($idFormule){
	//récupérer l'id_type_formule
	$champs=GetChampsEtTaille("formule");//[0] nom du champs, [1] taille du champ, [2]pour selection number(ceux qui donne l'unicité d'un enregistrement)
	$valeurs=GetEnregistrementInfo("formule",$idFormule);//sans l'id
	$idTypeFormule=-1;
	$cpt=0;
	foreach($champs as $champ){
		if($champ[0]=="prix_libre_unitaire"){
			return $valeurs[$cpt];
		}
		$cpt++;
	}
	return -1;
}
function GetNbParticipantsTotalPourUneFormule($idEcole,$idFormule){
//compte le nombre de lecons dans la formule
//Et si on est en groupe, chaque lecon aura un nb different de participants (1 seul a chaque fois pour les clients particuliers)
	$paramInTheEnd=" link_id_formule=".$idFormule;
	$allEnregistrements=GetAllTableInfo("lecon",$idEcole,$paramInTheEnd);
	$ret[0]=0;//Le nombre de participants total
	$ret[1]=0;//Le nombre de lecons de la formule
	foreach($allEnregistrements as $info){
		$ret[0]+=$info[7];//nb participants total
		$ret[1]++;//nb lecons
	}
	return $ret;
}
function GetMoniteurDeLaFormule($idEcole,$idFormule){
	$temp=GetMoniteurDeLaFormuleBD($idEcole,$idFormule);
	$ret['display']="";
	$ret['listingMoniteur']="";
	$cpt=0;
	foreach($temp as $t){
		if($cpt>0){
			$ret['display'].=", ";
			$ret['listingMoniteur'].=";";
		}
		$ret['display'].=$t['nomStaff'];
		$ret['listingMoniteur'].=$t['idStaff'];
		$cpt++;
	}
	if($cpt==1){
		$ret['display']="moniteur : ".$ret['display'].".";
	}
	if($cpt>1){
		$ret['display']="moniteurs : ".$ret['display'].".";
	}
	$ret['display'].=" ";
	return $ret;
}
function GetLeconsInfosFromFormuleDisplayForPdf($idEcole,$idFormule){
	$infos=GetLeconsInfosFromFormuleDisplayForPdfBD($idEcole,$idFormule);
	$cpt=0;
	$cptAdded=0;
	$temp=array();
	$display="";
	foreach($infos as $info){
		if(!in_array($info['nom'],$temp)){
			if($cptAdded>0){
				$display.=", ";
			}
			$display.=$info['nom'];
			$cptAdded++;
		}
		$temp[$cpt]=$info['nom'];
		$cpt++;
	}
	$display.=" (".count($infos)." leçon";
	$display.=count($infos)>1?"s":"";
	$date1="";
	$date2="";
	$cpt=0;
	foreach($infos as $info){
		if($infos[$cpt]['dateOnly']!=""){
			if($date1==""){
				$date1=$infos[$cpt]['dateOnly'];
			}
			else{
				$date2=$infos[$cpt]['dateOnly'];
			}
		}
		$cpt++;		
	}
	if($date1!=""){
		if($date2=="" or $date1==$date2){
			$display.=" le ".$date1;
		}
		else{
			$display.=" du ".$date1." au ".$date2;
		}
	}
	$display.=")";
	return $display;
}

// hash: b2e0b4df06e6faadf3ef7d97fb14a9213193116d34c59a86810335faf76de27f
?>
